/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model.decorator;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.SpriteReplacementModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.FramedModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class MaterialModelDecorator<C extends FramedModelContext>
extends ModelDecorator<C> {
    protected final DrawerModelStore.FrameMatSet matSet;
    protected final boolean shaded;

    public MaterialModelDecorator(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
        this.matSet = matSet;
        this.shaded = shaded;
    }

    @Override
    public boolean shouldRenderItem() {
        return true;
    }

    @Override
    public boolean shouldRenderBase(Supplier<C> contextSupplier) {
        FramedModelContext context = (FramedModelContext)contextSupplier.get();
        if (context == null) {
            return true;
        }
        MaterialData matData = context.materialData();
        return matData == null || matData.getEffectiveSide().m_41619_();
    }

    @Override
    public boolean shouldRenderBase(Supplier<C> contextSupplier, ItemStack stack) {
        return this.shouldRenderBase(contextSupplier);
    }

    @Override
    public void emitQuads(Supplier<C> contextSupplier, Consumer<BakedModel> emitModel) {
        FramedModelContext context = (FramedModelContext)contextSupplier.get();
        if (context == null) {
            return;
        }
        MaterialData matData = context.materialData();
        if (matData != null && !matData.getEffectiveSide().m_41619_()) {
            if (this.shaded && context.renderType() == RenderType.m_110466_()) {
                this.emitFramedOverlayQuads(context, emitModel);
            }
            if (context.renderType() == RenderType.m_110457_()) {
                this.emitFramedQuads(context, emitModel);
            }
        }
    }

    @Override
    public void emitItemQuads(Supplier<C> contextSupplier, Consumer<BakedModel> emitModel, ItemStack stack) {
        FramedModelContext context = (FramedModelContext)contextSupplier.get();
        if (context == null) {
            return;
        }
        MaterialData matData = context.materialData();
        if (matData != null && !matData.getEffectiveSide().m_41619_()) {
            this.emitFramedQuads(context, emitModel);
            if (this.shaded) {
                this.emitFramedOverlayQuads(context, emitModel);
            }
        }
    }

    @Override
    public List<RenderType> getRenderTypes(BlockState state) {
        if (this.shaded) {
            return List.of(RenderType.m_110457_(), RenderType.m_110466_());
        }
        return List.of(RenderType.m_110457_());
    }

    @Override
    public List<RenderType> getRenderTypes(ItemStack stack) {
        if (this.shaded) {
            return List.of(RenderType.m_110457_(), RenderType.m_110466_());
        }
        return List.of(RenderType.m_110457_());
    }

    public void emitFramedQuads(FramedModelContext context, Consumer<BakedModel> emitModel) {
        Block block = context.state().m_60734_();
        if (block instanceof IFramedBlock) {
            IFramedBlock fb = (IFramedBlock)block;
            MaterialData matData = context.materialData();
            if (matData != null && !matData.isEmpty()) {
                if (this.matSet.sidePart() != null && fb.supportsFrameMaterial(FrameMaterial.SIDE)) {
                    emitModel.accept(new SpriteReplacementModel(this.getStoreModel(context, this.matSet.sidePart()), matData.getEffectiveSide()));
                }
                if (this.matSet.trimPart() != null && fb.supportsFrameMaterial(FrameMaterial.TRIM)) {
                    emitModel.accept(new SpriteReplacementModel(this.getStoreModel(context, this.matSet.trimPart()), matData.getEffectiveTrim()));
                }
                if (this.matSet.frontPart() != null && fb.supportsFrameMaterial(FrameMaterial.FRONT)) {
                    emitModel.accept(new SpriteReplacementModel(this.getStoreModel(context, this.matSet.frontPart()), matData.getEffectiveFront()));
                }
            }
        }
    }

    public void emitFramedOverlayQuads(FramedModelContext context, Consumer<BakedModel> emitModel) {
        MaterialData matData = context.materialData();
        if (matData != null && !matData.isEmpty()) {
            if (this.matSet.shadeFrontPart() != null) {
                emitModel.accept(this.getStoreModel(context, this.matSet.shadeFrontPart()));
            }
            if (this.matSet.shadeSidePart() != null) {
                emitModel.accept(this.getStoreModel(context, this.matSet.shadeSidePart()));
            }
        }
    }

    protected abstract BakedModel getStoreModel(FramedModelContext var1, DrawerModelStore.DynamicPart var2);

    public static class FacingSizedOpen<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public FacingSizedOpen(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected BakedModel getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            Direction dir = (Direction)context.state().m_61143_((Property)BlockDrawers.f_54117_);
            boolean half = false;
            EnumCompDrawer open = EnumCompDrawer.OPEN1;
            Block block = context.state().m_60734_();
            if (block instanceof BlockCompDrawers) {
                BlockCompDrawers drawers = (BlockCompDrawers)block;
                half = drawers.isHalfDepth();
                open = (EnumCompDrawer)((Object)context.state().m_61143_(BlockCompDrawers.SLOTS));
            }
            return DrawerModelStore.getModel(part, dir, half, open);
        }
    }

    public static class FacingSizedSlotted<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public FacingSizedSlotted(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected BakedModel getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            Direction dir = (Direction)context.state().m_61143_((Property)BlockDrawers.f_54117_);
            boolean half = false;
            int count = 1;
            Block block = context.state().m_60734_();
            if (block instanceof BlockDrawers) {
                BlockDrawers drawers = (BlockDrawers)block;
                half = drawers.isHalfDepth();
                count = drawers.getDrawerCount();
            }
            return DrawerModelStore.getModel(part, dir, half, count);
        }
    }

    public static class FacingSized<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public FacingSized(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected BakedModel getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            Direction dir = (Direction)context.state().m_61143_((Property)BlockDrawers.f_54117_);
            boolean half = false;
            Block block = context.state().m_60734_();
            if (block instanceof BlockDrawers) {
                BlockDrawers drawers = (BlockDrawers)block;
                half = drawers.isHalfDepth();
            }
            return DrawerModelStore.getModel(part, dir, half);
        }
    }

    public static class Facing<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public Facing(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected BakedModel getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            Direction dir = (Direction)context.state().m_61143_((Property)BlockDrawers.f_54117_);
            return DrawerModelStore.getModel(part, dir);
        }
    }

    public static class Single<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public Single(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected BakedModel getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            return DrawerModelStore.getModel(part);
        }
    }
}

